#!/usr/bin/perl
package HTML::Mason;

use HTML::Mason;
use strict;
# use Apache::DBI instead of just plain DBI 
# if you want persistent database connections

use Apache::DBI;


# List of modules that you want to use from components (see Admin
# manual for details)
{ package HTML::Mason::Commands;
}

# Create Mason objects
#
my $parser = new HTML::Mason::Parser;

# you may need to change the paths below to reflect your system config
my $interp = new HTML::Mason::Interp (parser=>$parser,
  allow_recursive_autohandlers =>undef,
  comp_root=>'/usr/local/apache/htdocs/',
  data_dir=>'/usr/local/apache/mason/data');

my $ah = new HTML::Mason::ApacheHandler (interp=>$interp);

# create a global DB handle 
$parser->allow_globals(qw($dbh));

# set the appropriate tablename, username and password below

$interp->set_global(dbh => DBI->connect("DBI:mysql:test:localhost", "Web_user","Web_password")) 
|| die "Cannot connect to database";

# Activate the following if running httpd as root (the normal case).
# Resets ownership of all files created by Mason at startup. Change
# these to match your server's 'User' and 'Group'.
#
chown (scalar(getpwnam "nobody"), scalar(getgrnam "nobody"),
    $interp->files_written);

sub handler
{
  my ($r) = @_;

  # If you plan to intermix images in the same directory as
  # components, activate the following to prevent Mason from
  # evaluating image files as components.
  #
return -1 if $r->content_type && $r->content_type =~ /image/i;

  my $status = $ah->handle_request($r);
  
  return $status;
}

1;
